<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */

get_header(); 

//Comprobamos etapa educativas
$es_etapa = false;
$parents = get_post_ancestors( $post->ID );
if ( isset($parents[1]) ){
	$parent = get_post( $parents[1] );
	$class = $parent->post_name;
	
	
	
	if ( $class == 'etapas-educativas' || $class == 'departments' ){
		$es_etapa = true;
		
		$parent = get_post( $parents[0] );
		$etapa = $parent->post_name;
		$etapa = str_replace('eso', 'secundaria', $etapa);
	}
	
}

?>
	
	<div id="secundary-menu-wrapper">
	<?php 
	
	
		if ( $es_etapa ){
		
			if ( getActiveLanguage() == 'es' ){
				$etapas = array('nursery', 'infantil', 'primaria', 'secundaria', 'bachillerato');
				if ( in_array($etapa, $etapas) ) {
					wp_nav_menu( array( 'theme_location' => 'menu_etapas_'.$etapa, 'menu_class' => 'category-menu', 'after' => '') );
				}
				
			}
			else {
			
				$etapas_en = array('nursery' => 'nursery', 'infants' => 'infantil', 'primary' => 'primaria', 'secundaria-obligatory-secondary-education' => 'secundaria', 'bachillerato-sixth-form' => 'bachillerato');
				if ( isset($etapas_en[$etapa]) ) {
					wp_nav_menu( array( 'theme_location' => 'menu_etapas_'.$etapas_en[$etapa], 'menu_class' => 'category-menu', 'after' => '') );
				}
				
			}
			
		}
	?>	
	</div>
	
	<div id="primary" class="site-content<?php if ($es_etapa) echo ' nomargin'?>">
		<div id="content" role="main">
			
			<div class="breadcrumbs" xmlns:v="http://rdf.data-vocabulary.org/#">
		    <?php if(function_exists('bcn_display')) {
        		bcn_display();
    		}?>
			</div>
			
			<?php while ( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'content', 'page' ); ?>
				<?php comments_template( '', true ); ?>
			<?php endwhile; // end of the loop. ?>

		</div><!-- #content -->
	</div><!-- #primary -->

<?php if ( $es_etapa ) { ?>
	<div id="secondary_category" class="widget-area" role="complementary">
		<?php wp_nav_menu( array( 'theme_location' => 'menu_etapas_derecha', 'menu_class' => 'category-menu-right', 'after' => '') ); ?>
	</div>
<?php
}
else { 
	get_sidebar(); 
}

?>
<?php get_footer(); ?>

<!-- template: page -->