/**
 * Handles toggling the navigation menu for small screens and
 * accessibility for submenu items.
 */
( function() {
	var nav = document.getElementById( 'site-navigation' ), button, menu;
	if ( ! nav ) {
		return;
	}

	button = nav.getElementsByTagName( 'button' )[0];
	menu   = nav.getElementsByTagName( 'ul' )[0];
	if ( ! button ) {
		return;
	}

	// Hide button if menu is missing or empty.
	if ( ! menu || ! menu.childNodes.length ) {
		button.style.display = 'none';
		return;
	}

	button.onclick = function() {
		if ( -1 === menu.className.indexOf( 'nav-menu' ) ) {
			menu.className = 'nav-menu';
		}

		if ( -1 !== button.className.indexOf( 'toggled-on' ) ) {
			button.className = button.className.replace( ' toggled-on', '' );
			menu.className = menu.className.replace( ' toggled-on', '' );
		} else {
			button.className += ' toggled-on';
			menu.className += ' toggled-on';
		}
	};
} )();

// Better focus for hidden submenu items for accessibility.
( function( $ ) {
	$( '.main-navigation' ).find( 'a' ).on( 'focus.twentytwelve blur.twentytwelve', function() {
		$( this ).parents( '.menu-item, .page_item' ).toggleClass( 'focus' );
	} );

  if ( 'ontouchstart' in window ) {
    $('body').on( 'touchstart.twentytwelve',  '.menu-item-has-children > a, .page_item_has_children > a', function( e ) {
      var el = $( this ).parent( 'li' );

      if ( ! el.hasClass( 'focus' ) ) {
        e.preventDefault();
        el.toggleClass( 'focus' );
        el.siblings( '.focus').removeClass( 'focus' );
      }
    } );
  }
} )( jQuery );

( function( $ ) {
	
	function replaceImagenEnglish(id, image_es, image_en){

		if( $(id).length != 0) {
			var src = $(id).attr('src');
			src = src.replace(image_es, image_en);
			$(id).attr('src', src);
			$(id).attr('srcset', '');
			
		}
		
	}

	$(window).load(function(){
		
		$('div.entry-content').css('display', 'block');
		
		$.getScript( template_directory + '/js/mails.js');
		
		if ( $(window).width() > 600 ){
			$('#secondary').height( $('#primary').height() );	
		}
		else {
			//$('#educational-stages .stage:first-child').css('margin-left', ($(window).width() - 378)/2+'px' );
		}
		
		$('.open_fotos').click( function(){
			var id = $(this).data("article-id");	
			$('#post-'+id+' .entry-content a.fancybox:first-child').trigger('click');
		});
		
		//Correos formularios
		$('.email-destinatario input').val('tutorian1@humanitastrescantos.com'); //Por defecto
		
		$('.wpcf7-form .etapa select, .wpcf7-form .curso select, .wpcf7-form .grupo select').change( function(){
			
			var etapa = $('.wpcf7-form .etapa select').val();
			var curso = $('.wpcf7-form .curso select').val();
			var grupo = $('.wpcf7-form .grupo select').val();
			
			var mail = 'tutoria'+curso.toLowerCase();
			
			mail = mail.replace('3 años', 'infantil1');
			mail = mail.replace('4 años', 'infantil2');
			mail = mail.replace('5 años', 'infantil3');
			
			mail = mail+grupo.toLowerCase();
			
			//console.log(mail);
			
			if ( $.inArray(mail, mailsArray) != -1 ) {
				mail = mail +'@humanitastrescantos.com';			
				$('.email-destinatario input').val(mail);
			}
			else {
				alert('No existe esa grupo en el curso indicado');
			}
			
		});
		
		
		$('#menu-menu-superior > li.menu-item-has-children').click(function(e) {
	        var $el = $('ul',this);
	        $('#menu-menu-superior > li > ul').not($el).slideUp();
	        $el.stop(true, true).slideToggle(400);
	        return false;
	    });
	    $('#menu-menu-superior > li.menu-item-has-children > ul > li').click(function(e) {
	        e.stopPropagation();
	    });
		
		var f = new Date(); 
		var fecha = f.getDate() + "/" + (f.getMonth()+1) + "/" + f.getFullYear();
		
		$('#fecha_envio input').val(fecha);
		
		//Botones ingles
		if( $("#language_en").length != 0) {
			
			replaceImagenEnglish('#menu-item-475 img', 'menu-formularios.png', 'menu-formularios-en.jpg');
			replaceImagenEnglish('.more_articles img', 'ver_mas_noticias.png', 'ver_mas_noticias-en.jpg');
	
			replaceImagenEnglish('#menu-item-505 img', 'menu-proyectos.png', 'menu-proyectos-en.jpg');
			replaceImagenEnglish('#menu-item-506 img', 'menu-proyectos.png', 'menu-proyectos-en.jpg');
			replaceImagenEnglish('#menu-item-507 img', 'menu-proyectos.png', 'menu-proyectos-en.jpg');
			replaceImagenEnglish('#menu-item-508 img', 'menu-proyectos.png', 'menu-proyectos-en.jpg');
			replaceImagenEnglish('#menu-item-509 img', 'menu-proyectos.png', 'menu-proyectos-en.jpg');												
		}
		
		
	});
	
	
	
} )( jQuery );

