<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * For example, it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
	
	$home = ($paged <= 1);
	get_header();
	
	$cat = ( ICL_LANGUAGE_CODE == 'es' ) ? 'sin-categorizar' : 'uncategorized'; 
	
	if ( $home ) { //offset
		query_posts('posts_per_page=2&category_name='.$cat );
		echo '<div id="slider-wrapper">'.do_shortcode('[metaslider id=57]').'</div>'; 
	}
    else {    	
    	
    	query_posts('posts_per_page=10&category_name='.$cat.'&paged='.($paged-1) );
		//query_posts('posts_per_page=5&offset=2&category_name='.$cat.'&paged='.($paged-1) );
    	echo '<div id="secundary-menu-wrapper" class="year-selection">'.do_shortcode('[archives type="yearly"]').'</div>';
    }
    
?>

	<div id="primary" class="site-content has-slider">
		
		<?php 
		if ( $home && shortcode_exists('banner_portada') ) {  
			do_shortcode('[banner_portada]');
		} 
		?>
		
		<div id="header_primary"> <span>Noticias</span> </div>
		
		<div id="content" role="main">
		<?php if ( have_posts() ) : ?>

			<?php while ( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'content', get_post_format() ); ?>
			<?php endwhile; ?>

			<div class="more_articles">
				<?php echo get_next_posts_link('<img src="'.get_template_directory_uri().'/images/ver_mas_noticias.png" alt="Ver más noticias" />', ($GLOBALS['wp_query']->max_num_pages+1) ); ?>
			</div>
			

		<?php else : ?>

			<article id="post-0" class="post no-results not-found">

			<?php if ( current_user_can( 'edit_posts' ) ) :
				// Show a different message to a logged-in user who can add posts.
			?>
				<header class="entry-header">
					<h1 class="entry-title"><?php _e( 'No posts to display', 'twentytwelve' ); ?></h1>
				</header>

				<div class="entry-content">
					<p><?php printf( __( 'Ready to publish your first post? <a href="%s">Get started here</a>.', 'twentytwelve' ), admin_url( 'post-new.php' ) ); ?></p>
				</div><!-- .entry-content -->

			<?php else :
				// Show the default message to everyone else.
			?>
				<header class="entry-header">
					<h1 class="entry-title"><?php _e( 'Nothing Found', 'twentytwelve' ); ?></h1>
				</header>

				<div class="entry-content">
					<p><?php _e( 'Apologies, but no results were found. Perhaps searching will help find a related post.', 'twentytwelve' ); ?></p>
					<?php get_search_form(); ?>
				</div><!-- .entry-content -->
			<?php endif; // end current_user_can() check ?>

			</article><!-- #post-0 -->

		<?php endif; // end have_posts() check ?>
		
		<?php //echo do_shortcode('[archives type="yearly"]'); ?>
		
		</div><!-- #content -->
	</div><!-- #primary -->



<?php get_sidebar(); ?>
<?php get_footer(); ?>

<!-- template: index -->