<?php
/**
 * The Header template for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */
?><!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) & !(IE 8)]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php // Loads HTML5 JavaScript file to add support for HTML5 elements in older IE versions. ?>
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<?php wp_head(); ?>
<script> var template_directory = '<?php echo get_template_directory_uri(); ?>'; </script>
</head>

<body id="language_<?php echo getActiveLanguage() ?>" <?php body_class(); ?>>

<header id="masthead" class="site-header" role="banner">
   <div class="site-logo">
	<a href="<?php bloginfo('url'); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/humanitas-logo.png" alt="Humanitas. Bilingual School Tres Cantos" /></a>
   </div>
   <div class="site-social">
   		<div class="text"><span class="lang_es">Contacta con nosotros</span><span class="lang_en">Contact us at</span><br/>902 70 20 48</div>
   		<div class="links">
   			<a href="<?php bloginfo('url'); ?>/index.php/blogs/"><img src="<?php echo get_template_directory_uri(); ?>/images/blogger-logo.png" alt="Blogger"/></a>
   			<a href="https://twitter.com/humanitastc" onclick="window.open(this.href); return false;"><img src="<?php echo get_template_directory_uri(); ?>/images/twitter-logo.png" alt="Twitter"/></a>
   		</div>
   		
   </div>
</header><!-- #masthead -->

<div id="educational-stages">
	
	<div id="educational-stages-wrapper">
		<?php 
		$stages = array('nursery' => 'nursery-en', 'infantil' => 'infants', 'primaria' => 'primary', 'secundaria' => 'secondary', 'bachillerato' => 'sixth-form');
		
		$current_category = '';
		
		if ( !is_home() ){
	
			$category = get_the_category(); 		
			if ( isset($category[0]->slug) ){
				$current_category = $category[0]->slug;
			}
			else {
					
				$ancestors = get_post_ancestors( $post );
				foreach ($ancestors as $ancestor){
	
					$aux = get_post($ancestor);
					
					if ( $aux->post_name == 'eso' ) $aux->post_name = 'secundaria';
	
					if ( isset($stages[$aux->post_name]) ){
						$current_category = $aux->post_name;
					}
					else {
						$etapas_aux = array('nursery' => 'nursery', 'infants' => 'infants', 'primary' => 'primary', 'eso-obligatory-secondary-education' => 'secondary', 'bachillerato-sixth-form' => 'sixth-form', );
						if ( isset($etapas_aux[$aux->post_name]) ){
							$current_category = $etapas_aux[$aux->post_name];
						}			
					}
				
				}
			}
			
			
		}	
		
		foreach ( $stages as $stage_es => $stage_en ){ 
		
			if ( getActiveLanguage() == 'es' ){
				$category_slug = $stage_es;
				$category_name = $stage_es;
				
			}
			else {
				$category_slug = $stage_en;
				$category_name = str_replace('-en', '', $stage_en);
				$category_name = str_replace('-', ' ', $category_name);
			}
		
		?>

		<div class="stage_wrapper">
			<div class="stage">
				<a href="<?php bloginfo('url'); ?>/category/<?php echo $category_slug ?>/">
				<div id="stage-button-<?php echo $stage_es; ?>" class="stage-image-wrapper <?php if ( $stage_es == $current_category || $stage_en == $current_category ) echo 'current'; ?>" style="background: url('<?php echo get_template_directory_uri(); ?>/images/img-<?php echo $stage_es ?>.png') no-repeat">
					<img src="<?php echo get_template_directory_uri(); ?>/images/hover-stage.png" alt="<?php echo ucfirst($category_name); ?>" />				
				</div>
	
				<span><?php echo ucwords($category_name); ?></span>
	
				</a>
			</div>
		</div>
		
		<?php
		}
		?>
		
	</div>
	
</div>

<nav id="site-navigation" class="main-navigation" role="navigation">
    <button class="menu-toggle">
    	<div class="horizontal-bar"> &nbsp; </div>
    	<div class="horizontal-bar"> &nbsp; </div>
    	<div class="horizontal-bar"> &nbsp; </div>    	    	
    </button>
    <?php wp_nav_menu( array( 'theme_location' => 'primary', 'menu_class' => 'nav-menu') ); ?>
</nav><!-- #site-navigation -->


<div id="page" class="hfeed site">
				
	<div id="main" class="wrapper">