<?php
/**
 * The template for displaying Archive pages
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each specific one. For example, Twenty Twelve already
 * has tag.php for Tag archives, category.php for Category archives, and
 * author.php for Author archives.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Twelve
 * @since Twenty Twelve 1.0
 */

get_header(); 
?>
	
	<div id="secundary-menu-wrapper" class="year-selection"><?php echo do_shortcode('[archives type="yearly"]') ?></div>

	<div id="primary" class="site-content has-slider">	
		<div id="header_primary"> <span>Noticias</span> </div>		
		
		<?php if ( have_posts() ) : ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'content', get_post_format() ); ?>
			<?php endwhile; ?>

			<div class="more_articles">
				<?php echo get_next_posts_link('<img src="'.get_template_directory_uri().'/images/ver_mas_noticias.png" alt="Ver más noticias" />', ($GLOBALS['wp_query']->max_num_pages+1) ); ?>
			</div>

		<?php else : ?>
			<?php get_template_part( 'content', 'none' ); ?>
		<?php endif; ?>

		</div><!-- #content -->
	</section><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>

<!-- template: archive -->