<?php
	defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
	
	/*
	Plugin Name: Banner Portada Humanitas
	Description: Plugin para configurar el banner de la portada
	Version: 0.1
	*/
	
	
	/* Página de configuración y opciones */
	function banner_portada_admin_actions() {
 		add_options_page( 'Configuración Banner Portada', 'Configurar Banner Portada', 'manage_options', 'banner_portada', 'banner_portada_pagina_configuracion' );
	}
	add_action('admin_menu', 'banner_portada_admin_actions');	


	function banner_portada_pagina_configuracion() {
		include('banner-portada_pagina_configuracion.php');
	}


	/* Funcion para el shortcode. */
	function banner_portada_shortcode( $attributes ){
		
		$banner_portada_banner = get_option('banner_portada_banner');
		$banner_portada_link = get_option('banner_portada_link');		
		
		if ( strlen($banner_portada_banner) ) {
	
			echo '<div style="text-align: center">';
				
				if ( strlen($banner_portada_link) ){
					echo '<a href="'.$banner_portada_link.'">';
				}
				
					echo '<img alt="Banner" src="'.$banner_portada_banner.'">';
				
				if ( strlen($banner_portada_link) ){
					echo '</a>';
				}
				
			echo '</div>';
			
		}
		
		
		$banner_portada_popup = get_option('banner_portada_popup');
		
		if ( strlen($banner_portada_popup) ) {
			echo '<div style="display:none"> <a id="open_banner" href="#banner">Ver popup</a> <div id="banner"><img onclick="$.fancybox.close();" src="'.$banner_portada_popup.'" alt="Información banners"></div> </div>';
			echo '<script type="text/javascript" src="'.get_template_directory_uri().'/js/fancybox/popup.js"></script>';
		}
		
	}
	
	add_shortcode( 'banner_portada', 'banner_portada_shortcode' );		
	
	function my_enqueue_media_lib_uploader() {
	    wp_enqueue_media();
	}
	add_action('admin_enqueue_scripts', 'my_enqueue_media_lib_uploader');
	
?>